#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

bool poredjenje(const pair<double, double>& a, const pair<double, double>& b) { return a.first < b.first; }

double nadji_vreme_ktog_preticanja(int n, int k, vector<pair<double, double>>& trkaci) {
    vector<pair<double, double>> preticanja;
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (trkaci[i].second > trkaci[j].second) {
                double vreme = (trkaci[j].first - trkaci[i].first) / (trkaci[i].second - trkaci[j].second);
                preticanja.push_back({ vreme, 0 });
            }
        }
    }
    sort(preticanja.begin(), preticanja.end(), poredjenje);
    double vreme_ktog_preticanja = preticanja[k - 1].first;
    return vreme_ktog_preticanja;
}

int main() {
    int n, k;
    cin >> n;
    cin >> k;
    vector<pair<double, double>> trkaci(n);
    
    for (int i = 0; i < n; ++i) {
        double x, v;
        cin >> x >> v;
        trkaci[i] = { x, v };
    }

    double vreme_ktog_preticanja = nadji_vreme_ktog_preticanja(n, k, trkaci);
    cout << vreme_ktog_preticanja;
    return 0;
}